// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.SynonymGraphTokenFilterConverter))]
public sealed partial class SynonymGraphTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public SynonymGraphTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SynonymGraphTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SynonymGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Expands definitions for equivalent synonym rules. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? Expand { get; set; }

	/// <summary>
	/// <para>
	/// Sets the synonym rules format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymFormat? Format { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> ignores errors while parsing the synonym rules. It is important to note that only those synonym rules which cannot get parsed are ignored. Defaults to the value of the <c>updateable</c> setting.
	/// </para>
	/// </summary>
	public bool? Lenient { get; set; }

	/// <summary>
	/// <para>
	/// Used to define inline synonyms.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Synonyms { get; set; }

	/// <summary>
	/// <para>
	/// Used to provide a synonym file. This path must be absolute or relative to the <c>config</c> location.
	/// </para>
	/// </summary>
	public string? SynonymsPath { get; set; }

	/// <summary>
	/// <para>
	/// Provide a synonym set created via Synonyms Management APIs.
	/// </para>
	/// </summary>
	public string? SynonymsSet { get; set; }

	/// <summary>
	/// <para>
	/// Controls the tokenizers that will be used to tokenize the synonym, this parameter is for backwards compatibility for indices that created before 6.0.
	/// </para>
	/// </summary>
	public string? Tokenizer { get; set; }

	public string Type => "synonym_graph";

	/// <summary>
	/// <para>
	/// If <c>true</c> allows reloading search analyzers to pick up changes to synonym files. Only to be used for search analyzers. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? Updateable { get; set; }
	public string? Version { get; set; }
}

public readonly partial struct SynonymGraphTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SynonymGraphTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SynonymGraphTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter(Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Expands definitions for equivalent synonym rules. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Expand(bool? value = true)
	{
		Instance.Expand = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets the synonym rules format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Format(Elastic.Clients.Elasticsearch.Analysis.SynonymFormat? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> ignores errors while parsing the synonym rules. It is important to note that only those synonym rules which cannot get parsed are ignored. Defaults to the value of the <c>updateable</c> setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to define inline synonyms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Synonyms(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Synonyms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to define inline synonyms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Synonyms(params string[] values)
	{
		Instance.Synonyms = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to provide a synonym file. This path must be absolute or relative to the <c>config</c> location.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor SynonymsPath(string? value)
	{
		Instance.SynonymsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Provide a synonym set created via Synonyms Management APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor SynonymsSet(string? value)
	{
		Instance.SynonymsSet = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls the tokenizers that will be used to tokenize the synonym, this parameter is for backwards compatibility for indices that created before 6.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Tokenizer(string? value)
	{
		Instance.Tokenizer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> allows reloading search analyzers to pick up changes to synonym files. Only to be used for search analyzers. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Updateable(bool? value = true)
	{
		Instance.Updateable = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}