// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class SynonymFormatConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.SynonymFormat>
{
	private static readonly System.Text.Json.JsonEncodedText MemberSolr = System.Text.Json.JsonEncodedText.Encode("solr");
	private static readonly System.Text.Json.JsonEncodedText MemberWordnet = System.Text.Json.JsonEncodedText.Encode("wordnet");

	public override Elastic.Clients.Elasticsearch.Analysis.SynonymFormat Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberSolr))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SynonymFormat.Solr;
		}

		if (reader.ValueTextEquals(MemberWordnet))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SynonymFormat.Wordnet;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberSolr.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SynonymFormat.Solr;
		}

		if (string.Equals(value, MemberWordnet.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SynonymFormat.Wordnet;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.SynonymFormat)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.SynonymFormat value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.SynonymFormat.Solr:
				writer.WriteStringValue(MemberSolr);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SynonymFormat.Wordnet:
				writer.WriteStringValue(MemberWordnet);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.SynonymFormat)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.SynonymFormat ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.SynonymFormat value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}