// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class StopWordLanguageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage>
{
	private static readonly System.Text.Json.JsonEncodedText MemberArabic = System.Text.Json.JsonEncodedText.Encode("_arabic_");
	private static readonly System.Text.Json.JsonEncodedText MemberArmenian = System.Text.Json.JsonEncodedText.Encode("_armenian_");
	private static readonly System.Text.Json.JsonEncodedText MemberBasque = System.Text.Json.JsonEncodedText.Encode("_basque_");
	private static readonly System.Text.Json.JsonEncodedText MemberBengali = System.Text.Json.JsonEncodedText.Encode("_bengali_");
	private static readonly System.Text.Json.JsonEncodedText MemberBrazilian = System.Text.Json.JsonEncodedText.Encode("_brazilian_");
	private static readonly System.Text.Json.JsonEncodedText MemberBulgarian = System.Text.Json.JsonEncodedText.Encode("_bulgarian_");
	private static readonly System.Text.Json.JsonEncodedText MemberCatalan = System.Text.Json.JsonEncodedText.Encode("_catalan_");
	private static readonly System.Text.Json.JsonEncodedText MemberCjk = System.Text.Json.JsonEncodedText.Encode("_cjk_");
	private static readonly System.Text.Json.JsonEncodedText MemberCzech = System.Text.Json.JsonEncodedText.Encode("_czech_");
	private static readonly System.Text.Json.JsonEncodedText MemberDanish = System.Text.Json.JsonEncodedText.Encode("_danish_");
	private static readonly System.Text.Json.JsonEncodedText MemberDutch = System.Text.Json.JsonEncodedText.Encode("_dutch_");
	private static readonly System.Text.Json.JsonEncodedText MemberEnglish = System.Text.Json.JsonEncodedText.Encode("_english_");
	private static readonly System.Text.Json.JsonEncodedText MemberEstonian = System.Text.Json.JsonEncodedText.Encode("_estonian_");
	private static readonly System.Text.Json.JsonEncodedText MemberFinnish = System.Text.Json.JsonEncodedText.Encode("_finnish_");
	private static readonly System.Text.Json.JsonEncodedText MemberFrench = System.Text.Json.JsonEncodedText.Encode("_french_");
	private static readonly System.Text.Json.JsonEncodedText MemberGalician = System.Text.Json.JsonEncodedText.Encode("_galician_");
	private static readonly System.Text.Json.JsonEncodedText MemberGerman = System.Text.Json.JsonEncodedText.Encode("_german_");
	private static readonly System.Text.Json.JsonEncodedText MemberGreek = System.Text.Json.JsonEncodedText.Encode("_greek_");
	private static readonly System.Text.Json.JsonEncodedText MemberHindi = System.Text.Json.JsonEncodedText.Encode("_hindi_");
	private static readonly System.Text.Json.JsonEncodedText MemberHungarian = System.Text.Json.JsonEncodedText.Encode("_hungarian_");
	private static readonly System.Text.Json.JsonEncodedText MemberIndonesian = System.Text.Json.JsonEncodedText.Encode("_indonesian_");
	private static readonly System.Text.Json.JsonEncodedText MemberIrish = System.Text.Json.JsonEncodedText.Encode("_irish_");
	private static readonly System.Text.Json.JsonEncodedText MemberItalian = System.Text.Json.JsonEncodedText.Encode("_italian_");
	private static readonly System.Text.Json.JsonEncodedText MemberLatvian = System.Text.Json.JsonEncodedText.Encode("_latvian_");
	private static readonly System.Text.Json.JsonEncodedText MemberLithuanian = System.Text.Json.JsonEncodedText.Encode("_lithuanian_");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("_none_");
	private static readonly System.Text.Json.JsonEncodedText MemberNorwegian = System.Text.Json.JsonEncodedText.Encode("_norwegian_");
	private static readonly System.Text.Json.JsonEncodedText MemberPersian = System.Text.Json.JsonEncodedText.Encode("_persian_");
	private static readonly System.Text.Json.JsonEncodedText MemberPortuguese = System.Text.Json.JsonEncodedText.Encode("_portuguese_");
	private static readonly System.Text.Json.JsonEncodedText MemberRomanian = System.Text.Json.JsonEncodedText.Encode("_romanian_");
	private static readonly System.Text.Json.JsonEncodedText MemberRussian = System.Text.Json.JsonEncodedText.Encode("_russian_");
	private static readonly System.Text.Json.JsonEncodedText MemberSerbian = System.Text.Json.JsonEncodedText.Encode("_serbian_");
	private static readonly System.Text.Json.JsonEncodedText MemberSorani = System.Text.Json.JsonEncodedText.Encode("_sorani_");
	private static readonly System.Text.Json.JsonEncodedText MemberSpanish = System.Text.Json.JsonEncodedText.Encode("_spanish_");
	private static readonly System.Text.Json.JsonEncodedText MemberSwedish = System.Text.Json.JsonEncodedText.Encode("_swedish_");
	private static readonly System.Text.Json.JsonEncodedText MemberThai = System.Text.Json.JsonEncodedText.Encode("_thai_");
	private static readonly System.Text.Json.JsonEncodedText MemberTurkish = System.Text.Json.JsonEncodedText.Encode("_turkish_");

	public override Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberArabic))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Arabic;
		}

		if (reader.ValueTextEquals(MemberArmenian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Armenian;
		}

		if (reader.ValueTextEquals(MemberBasque))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Basque;
		}

		if (reader.ValueTextEquals(MemberBengali))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Bengali;
		}

		if (reader.ValueTextEquals(MemberBrazilian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Brazilian;
		}

		if (reader.ValueTextEquals(MemberBulgarian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Bulgarian;
		}

		if (reader.ValueTextEquals(MemberCatalan))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Catalan;
		}

		if (reader.ValueTextEquals(MemberCjk))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Cjk;
		}

		if (reader.ValueTextEquals(MemberCzech))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Czech;
		}

		if (reader.ValueTextEquals(MemberDanish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Danish;
		}

		if (reader.ValueTextEquals(MemberDutch))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Dutch;
		}

		if (reader.ValueTextEquals(MemberEnglish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.English;
		}

		if (reader.ValueTextEquals(MemberEstonian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Estonian;
		}

		if (reader.ValueTextEquals(MemberFinnish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Finnish;
		}

		if (reader.ValueTextEquals(MemberFrench))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.French;
		}

		if (reader.ValueTextEquals(MemberGalician))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Galician;
		}

		if (reader.ValueTextEquals(MemberGerman))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.German;
		}

		if (reader.ValueTextEquals(MemberGreek))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Greek;
		}

		if (reader.ValueTextEquals(MemberHindi))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Hindi;
		}

		if (reader.ValueTextEquals(MemberHungarian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Hungarian;
		}

		if (reader.ValueTextEquals(MemberIndonesian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Indonesian;
		}

		if (reader.ValueTextEquals(MemberIrish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Irish;
		}

		if (reader.ValueTextEquals(MemberItalian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Italian;
		}

		if (reader.ValueTextEquals(MemberLatvian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Latvian;
		}

		if (reader.ValueTextEquals(MemberLithuanian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Lithuanian;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.None;
		}

		if (reader.ValueTextEquals(MemberNorwegian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Norwegian;
		}

		if (reader.ValueTextEquals(MemberPersian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Persian;
		}

		if (reader.ValueTextEquals(MemberPortuguese))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Portuguese;
		}

		if (reader.ValueTextEquals(MemberRomanian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Romanian;
		}

		if (reader.ValueTextEquals(MemberRussian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Russian;
		}

		if (reader.ValueTextEquals(MemberSerbian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Serbian;
		}

		if (reader.ValueTextEquals(MemberSorani))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Sorani;
		}

		if (reader.ValueTextEquals(MemberSpanish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Spanish;
		}

		if (reader.ValueTextEquals(MemberSwedish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Swedish;
		}

		if (reader.ValueTextEquals(MemberThai))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Thai;
		}

		if (reader.ValueTextEquals(MemberTurkish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Turkish;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberArabic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Arabic;
		}

		if (string.Equals(value, MemberArmenian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Armenian;
		}

		if (string.Equals(value, MemberBasque.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Basque;
		}

		if (string.Equals(value, MemberBengali.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Bengali;
		}

		if (string.Equals(value, MemberBrazilian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Brazilian;
		}

		if (string.Equals(value, MemberBulgarian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Bulgarian;
		}

		if (string.Equals(value, MemberCatalan.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Catalan;
		}

		if (string.Equals(value, MemberCjk.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Cjk;
		}

		if (string.Equals(value, MemberCzech.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Czech;
		}

		if (string.Equals(value, MemberDanish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Danish;
		}

		if (string.Equals(value, MemberDutch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Dutch;
		}

		if (string.Equals(value, MemberEnglish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.English;
		}

		if (string.Equals(value, MemberEstonian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Estonian;
		}

		if (string.Equals(value, MemberFinnish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Finnish;
		}

		if (string.Equals(value, MemberFrench.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.French;
		}

		if (string.Equals(value, MemberGalician.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Galician;
		}

		if (string.Equals(value, MemberGerman.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.German;
		}

		if (string.Equals(value, MemberGreek.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Greek;
		}

		if (string.Equals(value, MemberHindi.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Hindi;
		}

		if (string.Equals(value, MemberHungarian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Hungarian;
		}

		if (string.Equals(value, MemberIndonesian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Indonesian;
		}

		if (string.Equals(value, MemberIrish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Irish;
		}

		if (string.Equals(value, MemberItalian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Italian;
		}

		if (string.Equals(value, MemberLatvian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Latvian;
		}

		if (string.Equals(value, MemberLithuanian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Lithuanian;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.None;
		}

		if (string.Equals(value, MemberNorwegian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Norwegian;
		}

		if (string.Equals(value, MemberPersian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Persian;
		}

		if (string.Equals(value, MemberPortuguese.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Portuguese;
		}

		if (string.Equals(value, MemberRomanian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Romanian;
		}

		if (string.Equals(value, MemberRussian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Russian;
		}

		if (string.Equals(value, MemberSerbian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Serbian;
		}

		if (string.Equals(value, MemberSorani.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Sorani;
		}

		if (string.Equals(value, MemberSpanish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Spanish;
		}

		if (string.Equals(value, MemberSwedish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Swedish;
		}

		if (string.Equals(value, MemberThai.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Thai;
		}

		if (string.Equals(value, MemberTurkish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Turkish;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Arabic:
				writer.WriteStringValue(MemberArabic);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Armenian:
				writer.WriteStringValue(MemberArmenian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Basque:
				writer.WriteStringValue(MemberBasque);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Bengali:
				writer.WriteStringValue(MemberBengali);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Brazilian:
				writer.WriteStringValue(MemberBrazilian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Bulgarian:
				writer.WriteStringValue(MemberBulgarian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Catalan:
				writer.WriteStringValue(MemberCatalan);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Cjk:
				writer.WriteStringValue(MemberCjk);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Czech:
				writer.WriteStringValue(MemberCzech);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Danish:
				writer.WriteStringValue(MemberDanish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Dutch:
				writer.WriteStringValue(MemberDutch);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.English:
				writer.WriteStringValue(MemberEnglish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Estonian:
				writer.WriteStringValue(MemberEstonian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Finnish:
				writer.WriteStringValue(MemberFinnish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.French:
				writer.WriteStringValue(MemberFrench);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Galician:
				writer.WriteStringValue(MemberGalician);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.German:
				writer.WriteStringValue(MemberGerman);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Greek:
				writer.WriteStringValue(MemberGreek);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Hindi:
				writer.WriteStringValue(MemberHindi);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Hungarian:
				writer.WriteStringValue(MemberHungarian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Indonesian:
				writer.WriteStringValue(MemberIndonesian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Irish:
				writer.WriteStringValue(MemberIrish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Italian:
				writer.WriteStringValue(MemberItalian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Latvian:
				writer.WriteStringValue(MemberLatvian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Lithuanian:
				writer.WriteStringValue(MemberLithuanian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.None:
				writer.WriteStringValue(MemberNone);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Norwegian:
				writer.WriteStringValue(MemberNorwegian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Persian:
				writer.WriteStringValue(MemberPersian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Portuguese:
				writer.WriteStringValue(MemberPortuguese);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Romanian:
				writer.WriteStringValue(MemberRomanian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Russian:
				writer.WriteStringValue(MemberRussian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Serbian:
				writer.WriteStringValue(MemberSerbian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Sorani:
				writer.WriteStringValue(MemberSorani);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Spanish:
				writer.WriteStringValue(MemberSpanish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Swedish:
				writer.WriteStringValue(MemberSwedish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Thai:
				writer.WriteStringValue(MemberThai);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage.Turkish:
				writer.WriteStringValue(MemberTurkish);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}