// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.StopTokenFilterConverter))]
public sealed partial class StopTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public StopTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public StopTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StopTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, stop word matching is case insensitive. For example, if <c>true</c>, a stop word of the matches and removes <c>The</c>, <c>THE</c>, or <c>the</c>. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? IgnoreCase { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the last token of a stream is removed if it’s a stop word. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? RemoveTrailing { get; set; }

	/// <summary>
	/// <para>
	/// Language value, such as <c>_arabic_</c> or <c>_thai_</c>. Defaults to <c>_english_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? Stopwords { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of stop words to remove.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each stop word in the file must be separated by a line break.
	/// </para>
	/// </summary>
	public string? StopwordsPath { get; set; }

	public string Type => "stop";

	public string? Version { get; set; }
}

public readonly partial struct StopTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StopTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StopTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter(Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, stop word matching is case insensitive. For example, if <c>true</c>, a stop word of the matches and removes <c>The</c>, <c>THE</c>, or <c>the</c>. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor IgnoreCase(bool? value = true)
	{
		Instance.IgnoreCase = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the last token of a stream is removed if it’s a stop word. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor RemoveTrailing(bool? value = true)
	{
		Instance.RemoveTrailing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Language value, such as <c>_arabic_</c> or <c>_thai_</c>. Defaults to <c>_english_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor Stopwords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Stopwords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of stop words to remove.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each stop word in the file must be separated by a line break.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor StopwordsPath(string? value)
	{
		Instance.StopwordsPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}