// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.StopAnalyzerConverter))]
public sealed partial class StopAnalyzer : Elastic.Clients.Elasticsearch.Analysis.IAnalyzer
{
#if NET7_0_OR_GREATER
	public StopAnalyzer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public StopAnalyzer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StopAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? Stopwords { get; set; }

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public string? StopwordsPath { get; set; }

	public string Type => "stop";

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public string? Version { get; set; }
}

public readonly partial struct StopAnalyzerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StopAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StopAnalyzerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer instance) => new Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer(Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor Stopwords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Stopwords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor StopwordsPath(string? value)
	{
		Instance.StopwordsPath = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}