// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.StandardAnalyzerConverter))]
public sealed partial class StandardAnalyzer : Elastic.Clients.Elasticsearch.Analysis.IAnalyzer
{
#if NET7_0_OR_GREATER
	public StandardAnalyzer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public StandardAnalyzer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StandardAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum token length. If a token is seen that exceeds this length then it is split at <c>max_token_length</c> intervals.
	/// Defaults to <c>255</c>.
	/// </para>
	/// </summary>
	public int? MaxTokenLength { get; set; }

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? Stopwords { get; set; }

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public string? StopwordsPath { get; set; }

	public string Type => "standard";
}

public readonly partial struct StandardAnalyzerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StandardAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StandardAnalyzerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer instance) => new Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer(Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The maximum token length. If a token is seen that exceeds this length then it is split at <c>max_token_length</c> intervals.
	/// Defaults to <c>255</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor MaxTokenLength(int? value)
	{
		Instance.MaxTokenLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor Stopwords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Stopwords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor StopwordsPath(string? value)
	{
		Instance.StopwordsPath = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}