// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.SnowballTokenFilterConverter))]
public sealed partial class SnowballTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public SnowballTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SnowballTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SnowballTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Controls the language used by the stemmer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage? Language { get; set; }

	public string Type => "snowball";

	public string? Version { get; set; }
}

public readonly partial struct SnowballTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnowballTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnowballTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter(Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Controls the language used by the stemmer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor Language(Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage? value)
	{
		Instance.Language = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}