// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class SnowballLanguageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage>
{
	private static readonly System.Text.Json.JsonEncodedText MemberArabic = System.Text.Json.JsonEncodedText.Encode("Arabic");
	private static readonly System.Text.Json.JsonEncodedText MemberArmenian = System.Text.Json.JsonEncodedText.Encode("Armenian");
	private static readonly System.Text.Json.JsonEncodedText MemberBasque = System.Text.Json.JsonEncodedText.Encode("Basque");
	private static readonly System.Text.Json.JsonEncodedText MemberCatalan = System.Text.Json.JsonEncodedText.Encode("Catalan");
	private static readonly System.Text.Json.JsonEncodedText MemberDanish = System.Text.Json.JsonEncodedText.Encode("Danish");
	private static readonly System.Text.Json.JsonEncodedText MemberDutch = System.Text.Json.JsonEncodedText.Encode("Dutch");
	private static readonly System.Text.Json.JsonEncodedText MemberEnglish = System.Text.Json.JsonEncodedText.Encode("English");
	private static readonly System.Text.Json.JsonEncodedText MemberEstonian = System.Text.Json.JsonEncodedText.Encode("Estonian");
	private static readonly System.Text.Json.JsonEncodedText MemberFinnish = System.Text.Json.JsonEncodedText.Encode("Finnish");
	private static readonly System.Text.Json.JsonEncodedText MemberFrench = System.Text.Json.JsonEncodedText.Encode("French");
	private static readonly System.Text.Json.JsonEncodedText MemberGerman = System.Text.Json.JsonEncodedText.Encode("German");
	private static readonly System.Text.Json.JsonEncodedText MemberGerman2 = System.Text.Json.JsonEncodedText.Encode("German2");
	private static readonly System.Text.Json.JsonEncodedText MemberHungarian = System.Text.Json.JsonEncodedText.Encode("Hungarian");
	private static readonly System.Text.Json.JsonEncodedText MemberIrish = System.Text.Json.JsonEncodedText.Encode("Irish");
	private static readonly System.Text.Json.JsonEncodedText MemberItalian = System.Text.Json.JsonEncodedText.Encode("Italian");
	private static readonly System.Text.Json.JsonEncodedText MemberKp = System.Text.Json.JsonEncodedText.Encode("Kp");
	private static readonly System.Text.Json.JsonEncodedText MemberLithuanian = System.Text.Json.JsonEncodedText.Encode("Lithuanian");
	private static readonly System.Text.Json.JsonEncodedText MemberLovins = System.Text.Json.JsonEncodedText.Encode("Lovins");
	private static readonly System.Text.Json.JsonEncodedText MemberNorwegian = System.Text.Json.JsonEncodedText.Encode("Norwegian");
	private static readonly System.Text.Json.JsonEncodedText MemberPorter = System.Text.Json.JsonEncodedText.Encode("Porter");
	private static readonly System.Text.Json.JsonEncodedText MemberPortuguese = System.Text.Json.JsonEncodedText.Encode("Portuguese");
	private static readonly System.Text.Json.JsonEncodedText MemberRomanian = System.Text.Json.JsonEncodedText.Encode("Romanian");
	private static readonly System.Text.Json.JsonEncodedText MemberRussian = System.Text.Json.JsonEncodedText.Encode("Russian");
	private static readonly System.Text.Json.JsonEncodedText MemberSerbian = System.Text.Json.JsonEncodedText.Encode("Serbian");
	private static readonly System.Text.Json.JsonEncodedText MemberSpanish = System.Text.Json.JsonEncodedText.Encode("Spanish");
	private static readonly System.Text.Json.JsonEncodedText MemberSwedish = System.Text.Json.JsonEncodedText.Encode("Swedish");
	private static readonly System.Text.Json.JsonEncodedText MemberTurkish = System.Text.Json.JsonEncodedText.Encode("Turkish");

	public override Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberArabic))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Arabic;
		}

		if (reader.ValueTextEquals(MemberArmenian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Armenian;
		}

		if (reader.ValueTextEquals(MemberBasque))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Basque;
		}

		if (reader.ValueTextEquals(MemberCatalan))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Catalan;
		}

		if (reader.ValueTextEquals(MemberDanish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Danish;
		}

		if (reader.ValueTextEquals(MemberDutch))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Dutch;
		}

		if (reader.ValueTextEquals(MemberEnglish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.English;
		}

		if (reader.ValueTextEquals(MemberEstonian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Estonian;
		}

		if (reader.ValueTextEquals(MemberFinnish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Finnish;
		}

		if (reader.ValueTextEquals(MemberFrench))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.French;
		}

		if (reader.ValueTextEquals(MemberGerman))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.German;
		}

		if (reader.ValueTextEquals(MemberGerman2))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.German2;
		}

		if (reader.ValueTextEquals(MemberHungarian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Hungarian;
		}

		if (reader.ValueTextEquals(MemberIrish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Irish;
		}

		if (reader.ValueTextEquals(MemberItalian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Italian;
		}

		if (reader.ValueTextEquals(MemberKp))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Kp;
		}

		if (reader.ValueTextEquals(MemberLithuanian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Lithuanian;
		}

		if (reader.ValueTextEquals(MemberLovins))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Lovins;
		}

		if (reader.ValueTextEquals(MemberNorwegian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Norwegian;
		}

		if (reader.ValueTextEquals(MemberPorter))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Porter;
		}

		if (reader.ValueTextEquals(MemberPortuguese))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Portuguese;
		}

		if (reader.ValueTextEquals(MemberRomanian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Romanian;
		}

		if (reader.ValueTextEquals(MemberRussian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Russian;
		}

		if (reader.ValueTextEquals(MemberSerbian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Serbian;
		}

		if (reader.ValueTextEquals(MemberSpanish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Spanish;
		}

		if (reader.ValueTextEquals(MemberSwedish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Swedish;
		}

		if (reader.ValueTextEquals(MemberTurkish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Turkish;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberArabic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Arabic;
		}

		if (string.Equals(value, MemberArmenian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Armenian;
		}

		if (string.Equals(value, MemberBasque.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Basque;
		}

		if (string.Equals(value, MemberCatalan.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Catalan;
		}

		if (string.Equals(value, MemberDanish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Danish;
		}

		if (string.Equals(value, MemberDutch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Dutch;
		}

		if (string.Equals(value, MemberEnglish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.English;
		}

		if (string.Equals(value, MemberEstonian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Estonian;
		}

		if (string.Equals(value, MemberFinnish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Finnish;
		}

		if (string.Equals(value, MemberFrench.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.French;
		}

		if (string.Equals(value, MemberGerman.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.German;
		}

		if (string.Equals(value, MemberGerman2.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.German2;
		}

		if (string.Equals(value, MemberHungarian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Hungarian;
		}

		if (string.Equals(value, MemberIrish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Irish;
		}

		if (string.Equals(value, MemberItalian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Italian;
		}

		if (string.Equals(value, MemberKp.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Kp;
		}

		if (string.Equals(value, MemberLithuanian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Lithuanian;
		}

		if (string.Equals(value, MemberLovins.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Lovins;
		}

		if (string.Equals(value, MemberNorwegian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Norwegian;
		}

		if (string.Equals(value, MemberPorter.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Porter;
		}

		if (string.Equals(value, MemberPortuguese.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Portuguese;
		}

		if (string.Equals(value, MemberRomanian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Romanian;
		}

		if (string.Equals(value, MemberRussian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Russian;
		}

		if (string.Equals(value, MemberSerbian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Serbian;
		}

		if (string.Equals(value, MemberSpanish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Spanish;
		}

		if (string.Equals(value, MemberSwedish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Swedish;
		}

		if (string.Equals(value, MemberTurkish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Turkish;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Arabic:
				writer.WriteStringValue(MemberArabic);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Armenian:
				writer.WriteStringValue(MemberArmenian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Basque:
				writer.WriteStringValue(MemberBasque);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Catalan:
				writer.WriteStringValue(MemberCatalan);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Danish:
				writer.WriteStringValue(MemberDanish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Dutch:
				writer.WriteStringValue(MemberDutch);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.English:
				writer.WriteStringValue(MemberEnglish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Estonian:
				writer.WriteStringValue(MemberEstonian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Finnish:
				writer.WriteStringValue(MemberFinnish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.French:
				writer.WriteStringValue(MemberFrench);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.German:
				writer.WriteStringValue(MemberGerman);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.German2:
				writer.WriteStringValue(MemberGerman2);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Hungarian:
				writer.WriteStringValue(MemberHungarian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Irish:
				writer.WriteStringValue(MemberIrish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Italian:
				writer.WriteStringValue(MemberItalian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Kp:
				writer.WriteStringValue(MemberKp);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Lithuanian:
				writer.WriteStringValue(MemberLithuanian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Lovins:
				writer.WriteStringValue(MemberLovins);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Norwegian:
				writer.WriteStringValue(MemberNorwegian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Porter:
				writer.WriteStringValue(MemberPorter);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Portuguese:
				writer.WriteStringValue(MemberPortuguese);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Romanian:
				writer.WriteStringValue(MemberRomanian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Russian:
				writer.WriteStringValue(MemberRussian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Serbian:
				writer.WriteStringValue(MemberSerbian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Spanish:
				writer.WriteStringValue(MemberSpanish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Swedish:
				writer.WriteStringValue(MemberSwedish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage.Turkish:
				writer.WriteStringValue(MemberTurkish);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}