// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.SnowballAnalyzerConverter))]
public sealed partial class SnowballAnalyzer : Elastic.Clients.Elasticsearch.Analysis.IAnalyzer
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnowballAnalyzer(Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage language)
	{
		Language = language;
	}
#if NET7_0_OR_GREATER
	public SnowballAnalyzer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SnowballAnalyzer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SnowballAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage Language { get; set; }
	public Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? Stopwords { get; set; }

	public string Type => "snowball";

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public string? Version { get; set; }
}

public readonly partial struct SnowballAnalyzerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnowballAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnowballAnalyzerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer instance) => new Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer(Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor Language(Elastic.Clients.Elasticsearch.Analysis.SnowballLanguage value)
	{
		Instance.Language = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor Stopwords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Stopwords = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}