// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.ShingleTokenFilterConverter))]
public sealed partial class ShingleTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public ShingleTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ShingleTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ShingleTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// String used in shingles as a replacement for empty positions that do not contain a token. This filler token is only used in shingles, not original unigrams. Defaults to an underscore (<c>_</c>).
	/// </para>
	/// </summary>
	public string? FillerToken { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of tokens to concatenate when creating shingles. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public int? MaxShingleSize { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of tokens to concatenate when creating shingles. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public int? MinShingleSize { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the output includes the original input tokens. If <c>false</c>, the output only includes shingles; the original input tokens are removed. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? OutputUnigrams { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the output includes the original input tokens only if no shingles are produced; if shingles are produced, the output only includes shingles. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? OutputUnigramsIfNoShingles { get; set; }

	/// <summary>
	/// <para>
	/// Separator used to concatenate adjacent tokens to form a shingle. Defaults to a space (<c>" "</c>).
	/// </para>
	/// </summary>
	public string? TokenSeparator { get; set; }

	public string Type => "shingle";

	public string? Version { get; set; }
}

public readonly partial struct ShingleTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShingleTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShingleTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter(Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// String used in shingles as a replacement for empty positions that do not contain a token. This filler token is only used in shingles, not original unigrams. Defaults to an underscore (<c>_</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor FillerToken(string? value)
	{
		Instance.FillerToken = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of tokens to concatenate when creating shingles. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor MaxShingleSize(int? value)
	{
		Instance.MaxShingleSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of tokens to concatenate when creating shingles. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor MinShingleSize(int? value)
	{
		Instance.MinShingleSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the output includes the original input tokens. If <c>false</c>, the output only includes shingles; the original input tokens are removed. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor OutputUnigrams(bool? value = true)
	{
		Instance.OutputUnigrams = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the output includes the original input tokens only if no shingles are produced; if shingles are produced, the output only includes shingles. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor OutputUnigramsIfNoShingles(bool? value = true)
	{
		Instance.OutputUnigramsIfNoShingles = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Separator used to concatenate adjacent tokens to form a shingle. Defaults to a space (<c>" "</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor TokenSeparator(string? value)
	{
		Instance.TokenSeparator = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}