// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class ShingleTokenFilterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter>
{
	private static readonly System.Text.Json.JsonEncodedText PropFillerToken = System.Text.Json.JsonEncodedText.Encode("filler_token");
	private static readonly System.Text.Json.JsonEncodedText PropMaxShingleSize = System.Text.Json.JsonEncodedText.Encode("max_shingle_size");
	private static readonly System.Text.Json.JsonEncodedText PropMinShingleSize = System.Text.Json.JsonEncodedText.Encode("min_shingle_size");
	private static readonly System.Text.Json.JsonEncodedText PropOutputUnigrams = System.Text.Json.JsonEncodedText.Encode("output_unigrams");
	private static readonly System.Text.Json.JsonEncodedText PropOutputUnigramsIfNoShingles = System.Text.Json.JsonEncodedText.Encode("output_unigrams_if_no_shingles");
	private static readonly System.Text.Json.JsonEncodedText PropTokenSeparator = System.Text.Json.JsonEncodedText.Encode("token_separator");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propFillerToken = default;
		LocalJsonValue<int?> propMaxShingleSize = default;
		LocalJsonValue<int?> propMinShingleSize = default;
		LocalJsonValue<bool?> propOutputUnigrams = default;
		LocalJsonValue<bool?> propOutputUnigramsIfNoShingles = default;
		LocalJsonValue<string?> propTokenSeparator = default;
		LocalJsonValue<string?> propVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFillerToken.TryReadProperty(ref reader, options, PropFillerToken, null))
			{
				continue;
			}

			if (propMaxShingleSize.TryReadProperty(ref reader, options, PropMaxShingleSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMinShingleSize.TryReadProperty(ref reader, options, PropMinShingleSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propOutputUnigrams.TryReadProperty(ref reader, options, PropOutputUnigrams, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propOutputUnigramsIfNoShingles.TryReadProperty(ref reader, options, PropOutputUnigramsIfNoShingles, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propTokenSeparator.TryReadProperty(ref reader, options, PropTokenSeparator, null))
			{
				continue;
			}

			if (reader.ValueTextEquals(PropType))
			{
				reader.SafeSkip();
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			FillerToken = propFillerToken.Value,
			MaxShingleSize = propMaxShingleSize.Value,
			MinShingleSize = propMinShingleSize.Value,
			OutputUnigrams = propOutputUnigrams.Value,
			OutputUnigramsIfNoShingles = propOutputUnigramsIfNoShingles.Value,
			TokenSeparator = propTokenSeparator.Value,
			Version = propVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFillerToken, value.FillerToken, null, null);
		writer.WriteProperty(options, PropMaxShingleSize, value.MaxShingleSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMinShingleSize, value.MinShingleSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropOutputUnigrams, value.OutputUnigrams, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropOutputUnigramsIfNoShingles, value.OutputUnigramsIfNoShingles, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropTokenSeparator, value.TokenSeparator, null, null);
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		writer.WriteEndObject();
	}
}