// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PredicateTokenFilterConverter))]
public sealed partial class PredicateTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PredicateTokenFilter(Elastic.Clients.Elasticsearch.Script script)
	{
		Script = script;
	}
#if NET7_0_OR_GREATER
	public PredicateTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PredicateTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PredicateTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Script containing a condition used to filter incoming tokens. Only tokens that match this script are included in the output.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Script Script { get; set; }

	public string Type => "predicate_token_filter";

	public string? Version { get; set; }
}

public readonly partial struct PredicateTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PredicateTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PredicateTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter(Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Script containing a condition used to filter incoming tokens. Only tokens that match this script are included in the output.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor Script(Elastic.Clients.Elasticsearch.Script value)
	{
		Instance.Script = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Script containing a condition used to filter incoming tokens. Only tokens that match this script are included in the output.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Script containing a condition used to filter incoming tokens. Only tokens that match this script are included in the output.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}