// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PhoneticTokenFilterConverter))]
public sealed partial class PhoneticTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhoneticTokenFilter(Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder encoder)
	{
		Encoder = encoder;
	}
#if NET7_0_OR_GREATER
	public PhoneticTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PhoneticTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PhoneticTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder Encoder { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>? Languageset { get; set; }
	public int? MaxCodeLen { get; set; }
	public Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType? NameType { get; set; }
	public bool? Replace { get; set; }
	public Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType? RuleType { get; set; }

	public string Type => "phonetic";

	public string? Version { get; set; }
}

public readonly partial struct PhoneticTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhoneticTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhoneticTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter(Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor Encoder(Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder value)
	{
		Instance.Encoder = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor Languageset(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>? value)
	{
		Instance.Languageset = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor Languageset(params Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage[] values)
	{
		Instance.Languageset = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor MaxCodeLen(int? value)
	{
		Instance.MaxCodeLen = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor NameType(Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType? value)
	{
		Instance.NameType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor Replace(bool? value = true)
	{
		Instance.Replace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor RuleType(Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType? value)
	{
		Instance.RuleType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}