// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class PhoneticTokenFilterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter>
{
	private static readonly System.Text.Json.JsonEncodedText PropEncoder = System.Text.Json.JsonEncodedText.Encode("encoder");
	private static readonly System.Text.Json.JsonEncodedText PropLanguageset = System.Text.Json.JsonEncodedText.Encode("languageset");
	private static readonly System.Text.Json.JsonEncodedText PropMaxCodeLen = System.Text.Json.JsonEncodedText.Encode("max_code_len");
	private static readonly System.Text.Json.JsonEncodedText PropNameType = System.Text.Json.JsonEncodedText.Encode("name_type");
	private static readonly System.Text.Json.JsonEncodedText PropReplace = System.Text.Json.JsonEncodedText.Encode("replace");
	private static readonly System.Text.Json.JsonEncodedText PropRuleType = System.Text.Json.JsonEncodedText.Encode("rule_type");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder> propEncoder = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>?> propLanguageset = default;
		LocalJsonValue<int?> propMaxCodeLen = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType?> propNameType = default;
		LocalJsonValue<bool?> propReplace = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType?> propRuleType = default;
		LocalJsonValue<string?> propVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propEncoder.TryReadProperty(ref reader, options, PropEncoder, null))
			{
				continue;
			}

			if (propLanguageset.TryReadProperty(ref reader, options, PropLanguageset, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>(o, null)))
			{
				continue;
			}

			if (propMaxCodeLen.TryReadProperty(ref reader, options, PropMaxCodeLen, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNameType.TryReadProperty(ref reader, options, PropNameType, static Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType>(o)))
			{
				continue;
			}

			if (propReplace.TryReadProperty(ref reader, options, PropReplace, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propRuleType.TryReadProperty(ref reader, options, PropRuleType, static Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType>(o)))
			{
				continue;
			}

			if (reader.ValueTextEquals(PropType))
			{
				reader.SafeSkip();
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Encoder = propEncoder.Value,
			Languageset = propLanguageset.Value,
			MaxCodeLen = propMaxCodeLen.Value,
			NameType = propNameType.Value,
			Replace = propReplace.Value,
			RuleType = propRuleType.Value,
			Version = propVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropEncoder, value.Encoder, null, null);
		writer.WriteProperty(options, PropLanguageset, value.Languageset, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>? v) => w.WriteSingleOrManyCollectionValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>(o, v, null));
		writer.WriteProperty(options, PropMaxCodeLen, value.MaxCodeLen, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNameType, value.NameType, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType>(o, v));
		writer.WriteProperty(options, PropReplace, value.Replace, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropRuleType, value.RuleType, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType>(o, v));
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		writer.WriteEndObject();
	}
}