// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class PhoneticRuleTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberApprox = System.Text.Json.JsonEncodedText.Encode("approx");
	private static readonly System.Text.Json.JsonEncodedText MemberExact = System.Text.Json.JsonEncodedText.Encode("exact");

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberApprox))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType.Approx;
		}

		if (reader.ValueTextEquals(MemberExact))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType.Exact;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberApprox.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType.Approx;
		}

		if (string.Equals(value, MemberExact.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType.Exact;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType.Approx:
				writer.WriteStringValue(MemberApprox);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType.Exact:
				writer.WriteStringValue(MemberExact);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticRuleType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}