// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class PhoneticNameTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAshkenazi = System.Text.Json.JsonEncodedText.Encode("ashkenazi");
	private static readonly System.Text.Json.JsonEncodedText MemberGeneric = System.Text.Json.JsonEncodedText.Encode("generic");
	private static readonly System.Text.Json.JsonEncodedText MemberSephardic = System.Text.Json.JsonEncodedText.Encode("sephardic");

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAshkenazi))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Ashkenazi;
		}

		if (reader.ValueTextEquals(MemberGeneric))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Generic;
		}

		if (reader.ValueTextEquals(MemberSephardic))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Sephardic;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAshkenazi.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Ashkenazi;
		}

		if (string.Equals(value, MemberGeneric.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Generic;
		}

		if (string.Equals(value, MemberSephardic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Sephardic;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Ashkenazi:
				writer.WriteStringValue(MemberAshkenazi);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Generic:
				writer.WriteStringValue(MemberGeneric);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType.Sephardic:
				writer.WriteStringValue(MemberSephardic);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticNameType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}