// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class PhoneticLanguageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAny = System.Text.Json.JsonEncodedText.Encode("any");
	private static readonly System.Text.Json.JsonEncodedText MemberCommon = System.Text.Json.JsonEncodedText.Encode("common");
	private static readonly System.Text.Json.JsonEncodedText MemberCyrillic = System.Text.Json.JsonEncodedText.Encode("cyrillic");
	private static readonly System.Text.Json.JsonEncodedText MemberEnglish = System.Text.Json.JsonEncodedText.Encode("english");
	private static readonly System.Text.Json.JsonEncodedText MemberFrench = System.Text.Json.JsonEncodedText.Encode("french");
	private static readonly System.Text.Json.JsonEncodedText MemberGerman = System.Text.Json.JsonEncodedText.Encode("german");
	private static readonly System.Text.Json.JsonEncodedText MemberHebrew = System.Text.Json.JsonEncodedText.Encode("hebrew");
	private static readonly System.Text.Json.JsonEncodedText MemberHungarian = System.Text.Json.JsonEncodedText.Encode("hungarian");
	private static readonly System.Text.Json.JsonEncodedText MemberPolish = System.Text.Json.JsonEncodedText.Encode("polish");
	private static readonly System.Text.Json.JsonEncodedText MemberRomanian = System.Text.Json.JsonEncodedText.Encode("romanian");
	private static readonly System.Text.Json.JsonEncodedText MemberRussian = System.Text.Json.JsonEncodedText.Encode("russian");
	private static readonly System.Text.Json.JsonEncodedText MemberSpanish = System.Text.Json.JsonEncodedText.Encode("spanish");

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAny))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Any;
		}

		if (reader.ValueTextEquals(MemberCommon))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Common;
		}

		if (reader.ValueTextEquals(MemberCyrillic))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Cyrillic;
		}

		if (reader.ValueTextEquals(MemberEnglish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.English;
		}

		if (reader.ValueTextEquals(MemberFrench))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.French;
		}

		if (reader.ValueTextEquals(MemberGerman))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.German;
		}

		if (reader.ValueTextEquals(MemberHebrew))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Hebrew;
		}

		if (reader.ValueTextEquals(MemberHungarian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Hungarian;
		}

		if (reader.ValueTextEquals(MemberPolish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Polish;
		}

		if (reader.ValueTextEquals(MemberRomanian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Romanian;
		}

		if (reader.ValueTextEquals(MemberRussian))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Russian;
		}

		if (reader.ValueTextEquals(MemberSpanish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Spanish;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAny.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Any;
		}

		if (string.Equals(value, MemberCommon.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Common;
		}

		if (string.Equals(value, MemberCyrillic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Cyrillic;
		}

		if (string.Equals(value, MemberEnglish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.English;
		}

		if (string.Equals(value, MemberFrench.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.French;
		}

		if (string.Equals(value, MemberGerman.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.German;
		}

		if (string.Equals(value, MemberHebrew.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Hebrew;
		}

		if (string.Equals(value, MemberHungarian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Hungarian;
		}

		if (string.Equals(value, MemberPolish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Polish;
		}

		if (string.Equals(value, MemberRomanian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Romanian;
		}

		if (string.Equals(value, MemberRussian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Russian;
		}

		if (string.Equals(value, MemberSpanish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Spanish;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Any:
				writer.WriteStringValue(MemberAny);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Common:
				writer.WriteStringValue(MemberCommon);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Cyrillic:
				writer.WriteStringValue(MemberCyrillic);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.English:
				writer.WriteStringValue(MemberEnglish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.French:
				writer.WriteStringValue(MemberFrench);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.German:
				writer.WriteStringValue(MemberGerman);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Hebrew:
				writer.WriteStringValue(MemberHebrew);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Hungarian:
				writer.WriteStringValue(MemberHungarian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Polish:
				writer.WriteStringValue(MemberPolish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Romanian:
				writer.WriteStringValue(MemberRomanian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Russian:
				writer.WriteStringValue(MemberRussian);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage.Spanish:
				writer.WriteStringValue(MemberSpanish);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticLanguage value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}