// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class PhoneticEncoderConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBeiderMorse = System.Text.Json.JsonEncodedText.Encode("beider_morse");
	private static readonly System.Text.Json.JsonEncodedText MemberCaverphone1 = System.Text.Json.JsonEncodedText.Encode("caverphone1");
	private static readonly System.Text.Json.JsonEncodedText MemberCaverphone2 = System.Text.Json.JsonEncodedText.Encode("caverphone2");
	private static readonly System.Text.Json.JsonEncodedText MemberCologne = System.Text.Json.JsonEncodedText.Encode("cologne");
	private static readonly System.Text.Json.JsonEncodedText MemberDaitchMokotoff = System.Text.Json.JsonEncodedText.Encode("daitch_mokotoff");
	private static readonly System.Text.Json.JsonEncodedText MemberDoubleMetaphone = System.Text.Json.JsonEncodedText.Encode("double_metaphone");
	private static readonly System.Text.Json.JsonEncodedText MemberHaasephonetik = System.Text.Json.JsonEncodedText.Encode("haasephonetik");
	private static readonly System.Text.Json.JsonEncodedText MemberKoelnerphonetik = System.Text.Json.JsonEncodedText.Encode("koelnerphonetik");
	private static readonly System.Text.Json.JsonEncodedText MemberMetaphone = System.Text.Json.JsonEncodedText.Encode("metaphone");
	private static readonly System.Text.Json.JsonEncodedText MemberNysiis = System.Text.Json.JsonEncodedText.Encode("nysiis");
	private static readonly System.Text.Json.JsonEncodedText MemberRefinedSoundex = System.Text.Json.JsonEncodedText.Encode("refined_soundex");
	private static readonly System.Text.Json.JsonEncodedText MemberSoundex = System.Text.Json.JsonEncodedText.Encode("soundex");

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBeiderMorse))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.BeiderMorse;
		}

		if (reader.ValueTextEquals(MemberCaverphone1))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Caverphone1;
		}

		if (reader.ValueTextEquals(MemberCaverphone2))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Caverphone2;
		}

		if (reader.ValueTextEquals(MemberCologne))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Cologne;
		}

		if (reader.ValueTextEquals(MemberDaitchMokotoff))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.DaitchMokotoff;
		}

		if (reader.ValueTextEquals(MemberDoubleMetaphone))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.DoubleMetaphone;
		}

		if (reader.ValueTextEquals(MemberHaasephonetik))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Haasephonetik;
		}

		if (reader.ValueTextEquals(MemberKoelnerphonetik))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Koelnerphonetik;
		}

		if (reader.ValueTextEquals(MemberMetaphone))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Metaphone;
		}

		if (reader.ValueTextEquals(MemberNysiis))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Nysiis;
		}

		if (reader.ValueTextEquals(MemberRefinedSoundex))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.RefinedSoundex;
		}

		if (reader.ValueTextEquals(MemberSoundex))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Soundex;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBeiderMorse.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.BeiderMorse;
		}

		if (string.Equals(value, MemberCaverphone1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Caverphone1;
		}

		if (string.Equals(value, MemberCaverphone2.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Caverphone2;
		}

		if (string.Equals(value, MemberCologne.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Cologne;
		}

		if (string.Equals(value, MemberDaitchMokotoff.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.DaitchMokotoff;
		}

		if (string.Equals(value, MemberDoubleMetaphone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.DoubleMetaphone;
		}

		if (string.Equals(value, MemberHaasephonetik.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Haasephonetik;
		}

		if (string.Equals(value, MemberKoelnerphonetik.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Koelnerphonetik;
		}

		if (string.Equals(value, MemberMetaphone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Metaphone;
		}

		if (string.Equals(value, MemberNysiis.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Nysiis;
		}

		if (string.Equals(value, MemberRefinedSoundex.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.RefinedSoundex;
		}

		if (string.Equals(value, MemberSoundex.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Soundex;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.BeiderMorse:
				writer.WriteStringValue(MemberBeiderMorse);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Caverphone1:
				writer.WriteStringValue(MemberCaverphone1);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Caverphone2:
				writer.WriteStringValue(MemberCaverphone2);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Cologne:
				writer.WriteStringValue(MemberCologne);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.DaitchMokotoff:
				writer.WriteStringValue(MemberDaitchMokotoff);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.DoubleMetaphone:
				writer.WriteStringValue(MemberDoubleMetaphone);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Haasephonetik:
				writer.WriteStringValue(MemberHaasephonetik);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Koelnerphonetik:
				writer.WriteStringValue(MemberKoelnerphonetik);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Metaphone:
				writer.WriteStringValue(MemberMetaphone);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Nysiis:
				writer.WriteStringValue(MemberNysiis);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.RefinedSoundex:
				writer.WriteStringValue(MemberRefinedSoundex);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder.Soundex:
				writer.WriteStringValue(MemberSoundex);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.PhoneticEncoder value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}