// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PatternTokenizerConverter))]
public sealed partial class PatternTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
#if NET7_0_OR_GREATER
	public PatternTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PatternTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PatternTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? Flags { get; set; }
	public int? Group { get; set; }
	public string? Pattern { get; set; }

	public string Type => "pattern";

	public string? Version { get; set; }
}

public readonly partial struct PatternTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer(Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor Flags(string? value)
	{
		Instance.Flags = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor Group(int? value)
	{
		Instance.Group = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor Pattern(string? value)
	{
		Instance.Pattern = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}