// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PatternReplaceTokenFilterConverter))]
public sealed partial class PatternReplaceTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternReplaceTokenFilter(string pattern)
	{
		Pattern = pattern;
	}
#if NET7_0_OR_GREATER
	public PatternReplaceTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PatternReplaceTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PatternReplaceTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, all substrings matching the pattern parameter’s regular expression are replaced. If <c>false</c>, the filter replaces only the first matching substring in each token. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? All { get; set; }
	public string? Flags { get; set; }

	/// <summary>
	/// <para>
	/// Regular expression, written in Java’s regular expression syntax. The filter replaces token substrings matching this pattern with the substring in the <c>replacement</c> parameter.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Pattern { get; set; }

	/// <summary>
	/// <para>
	/// Replacement substring. Defaults to an empty substring (<c>""</c>).
	/// </para>
	/// </summary>
	public string? Replacement { get; set; }

	public string Type => "pattern_replace";

	public string? Version { get; set; }
}

public readonly partial struct PatternReplaceTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternReplaceTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternReplaceTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter(Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, all substrings matching the pattern parameter’s regular expression are replaced. If <c>false</c>, the filter replaces only the first matching substring in each token. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor All(bool? value = true)
	{
		Instance.All = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor Flags(string? value)
	{
		Instance.Flags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regular expression, written in Java’s regular expression syntax. The filter replaces token substrings matching this pattern with the substring in the <c>replacement</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor Pattern(string value)
	{
		Instance.Pattern = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Replacement substring. Defaults to an empty substring (<c>""</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor Replacement(string? value)
	{
		Instance.Replacement = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}