// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PatternReplaceCharFilterConverter))]
public sealed partial class PatternReplaceCharFilter : Elastic.Clients.Elasticsearch.Analysis.ICharFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternReplaceCharFilter(string pattern)
	{
		Pattern = pattern;
	}
#if NET7_0_OR_GREATER
	public PatternReplaceCharFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PatternReplaceCharFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PatternReplaceCharFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? Flags { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Pattern { get; set; }
	public string? Replacement { get; set; }

	public string Type => "pattern_replace";

	public string? Version { get; set; }
}

public readonly partial struct PatternReplaceCharFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternReplaceCharFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternReplaceCharFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter(Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor Flags(string? value)
	{
		Instance.Flags = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor Pattern(string value)
	{
		Instance.Pattern = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor Replacement(string? value)
	{
		Instance.Replacement = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}