// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PatternCaptureTokenFilterConverter))]
public sealed partial class PatternCaptureTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternCaptureTokenFilter(System.Collections.Generic.ICollection<string> patterns)
	{
		Patterns = patterns;
	}
#if NET7_0_OR_GREATER
	public PatternCaptureTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PatternCaptureTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PatternCaptureTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A list of regular expressions to match.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Patterns { get; set; }

	/// <summary>
	/// <para>
	/// If set to <c>true</c> (the default) it will emit the original token.
	/// </para>
	/// </summary>
	public bool? PreserveOriginal { get; set; }

	public string Type => "pattern_capture";

	public string? Version { get; set; }
}

public readonly partial struct PatternCaptureTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternCaptureTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternCaptureTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter(Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of regular expressions to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor Patterns(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Patterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of regular expressions to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor Patterns(params string[] values)
	{
		Instance.Patterns = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If set to <c>true</c> (the default) it will emit the original token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor PreserveOriginal(bool? value = true)
	{
		Instance.PreserveOriginal = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}