// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PatternAnalyzerConverter))]
public sealed partial class PatternAnalyzer : Elastic.Clients.Elasticsearch.Analysis.IAnalyzer
{
#if NET7_0_OR_GREATER
	public PatternAnalyzer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PatternAnalyzer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PatternAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Java regular expression flags. Flags should be pipe-separated, eg "CASE_INSENSITIVE|COMMENTS".
	/// </para>
	/// </summary>
	public string? Flags { get; set; }

	/// <summary>
	/// <para>
	/// Should terms be lowercased or not.
	/// Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? Lowercase { get; set; }

	/// <summary>
	/// <para>
	/// A Java regular expression.
	/// Defaults to <c>\W+</c>.
	/// </para>
	/// </summary>
	public string? Pattern { get; set; }

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? Stopwords { get; set; }

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public string? StopwordsPath { get; set; }

	public string Type => "pattern";

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public string? Version { get; set; }
}

public readonly partial struct PatternAnalyzerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PatternAnalyzerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer instance) => new Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer(Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Java regular expression flags. Flags should be pipe-separated, eg "CASE_INSENSITIVE|COMMENTS".
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor Flags(string? value)
	{
		Instance.Flags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Should terms be lowercased or not.
	/// Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor Lowercase(bool? value = true)
	{
		Instance.Lowercase = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A Java regular expression.
	/// Defaults to <c>\W+</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor Pattern(string? value)
	{
		Instance.Pattern = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor Stopwords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Stopwords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor StopwordsPath(string? value)
	{
		Instance.StopwordsPath = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}