// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.PathHierarchyTokenizerConverter))]
public sealed partial class PathHierarchyTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
#if NET7_0_OR_GREATER
	public PathHierarchyTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PathHierarchyTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PathHierarchyTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public int? BufferSize { get; set; }
	public string? Delimiter { get; set; }
	public string? Replacement { get; set; }
	public bool? Reverse { get; set; }
	public int? Skip { get; set; }

	public string Type => "path_hierarchy";

	public string? Version { get; set; }
}

public readonly partial struct PathHierarchyTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PathHierarchyTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PathHierarchyTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer(Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor BufferSize(int? value)
	{
		Instance.BufferSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor Delimiter(string? value)
	{
		Instance.Delimiter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor Replacement(string? value)
	{
		Instance.Replacement = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor Reverse(bool? value = true)
	{
		Instance.Reverse = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor Skip(int? value)
	{
		Instance.Skip = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}