// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.NormalizersConverter))]
public sealed partial class Normalizers : Elastic.Clients.Elasticsearch.IsADictionary<string, Elastic.Clients.Elasticsearch.Analysis.INormalizer>
{
	public Normalizers()
	{
	}

	public Normalizers(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Analysis.INormalizer> backingDictionary) : base(backingDictionary)
	{
	}

	public void Add(string key, Elastic.Clients.Elasticsearch.Analysis.INormalizer value) => BackingDictionary.Add(Sanitize(key), value);
	public bool TryGetNormalizer(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.Analysis.INormalizer value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetNormalizer<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, INormalizer
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}
}

public readonly partial struct NormalizersDescriptor
{
	private readonly Elastic.Clients.Elasticsearch.Analysis.Normalizers _items = new();

	private Elastic.Clients.Elasticsearch.Analysis.Normalizers Value => _items;

	public NormalizersDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor Custom(string key, Elastic.Clients.Elasticsearch.Analysis.CustomNormalizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor Custom(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CustomNormalizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor Custom(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CustomNormalizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CustomNormalizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor Lowercase(string key, Elastic.Clients.Elasticsearch.Analysis.LowercaseNormalizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor Lowercase(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LowercaseNormalizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor Lowercase(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LowercaseNormalizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LowercaseNormalizerDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.Normalizers Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.Normalizers();
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.NormalizersDescriptor();
		action.Invoke(builder);
		return builder.Value;
	}
}