// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.NoriTokenizerConverter))]
public sealed partial class NoriTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
#if NET7_0_OR_GREATER
	public NoriTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public NoriTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NoriTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode? DecompoundMode { get; set; }
	public bool? DiscardPunctuation { get; set; }

	public string Type => "nori_tokenizer";

	public string? UserDictionary { get; set; }
	public System.Collections.Generic.ICollection<string>? UserDictionaryRules { get; set; }
	public string? Version { get; set; }
}

public readonly partial struct NoriTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NoriTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NoriTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer(Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor DecompoundMode(Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode? value)
	{
		Instance.DecompoundMode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor DiscardPunctuation(bool? value = true)
	{
		Instance.DiscardPunctuation = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor UserDictionary(string? value)
	{
		Instance.UserDictionary = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor UserDictionaryRules(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.UserDictionaryRules = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor UserDictionaryRules(params string[] values)
	{
		Instance.UserDictionaryRules = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}