// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.NoriPartOfSpeechTokenFilterConverter))]
public sealed partial class NoriPartOfSpeechTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public NoriPartOfSpeechTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public NoriPartOfSpeechTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NoriPartOfSpeechTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// An array of part-of-speech tags that should be removed.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Stoptags { get; set; }

	public string Type => "nori_part_of_speech";

	public string? Version { get; set; }
}

public readonly partial struct NoriPartOfSpeechTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NoriPartOfSpeechTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NoriPartOfSpeechTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter(Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An array of part-of-speech tags that should be removed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor Stoptags(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stoptags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of part-of-speech tags that should be removed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor Stoptags(params string[] values)
	{
		Instance.Stoptags = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}