// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class NoriDecompoundModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDiscard = System.Text.Json.JsonEncodedText.Encode("discard");
	private static readonly System.Text.Json.JsonEncodedText MemberMixed = System.Text.Json.JsonEncodedText.Encode("mixed");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("none");

	public override Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDiscard))
		{
			return Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.Discard;
		}

		if (reader.ValueTextEquals(MemberMixed))
		{
			return Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.Mixed;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.None;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDiscard.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.Discard;
		}

		if (string.Equals(value, MemberMixed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.Mixed;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.None;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.Discard:
				writer.WriteStringValue(MemberDiscard);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.Mixed:
				writer.WriteStringValue(MemberMixed);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode.None:
				writer.WriteStringValue(MemberNone);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.NoriDecompoundMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}