// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.NGramTokenFilterConverter))]
public sealed partial class NGramTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public NGramTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public NGramTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Maximum length of characters in a gram. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public int? MaxGram { get; set; }

	/// <summary>
	/// <para>
	/// Minimum length of characters in a gram. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public int? MinGram { get; set; }

	/// <summary>
	/// <para>
	/// Emits original token when set to <c>true</c>. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? PreserveOriginal { get; set; }

	public string Type => "ngram";

	public string? Version { get; set; }
}

public readonly partial struct NGramTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NGramTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NGramTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter(Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Maximum length of characters in a gram. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor MaxGram(int? value)
	{
		Instance.MaxGram = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum length of characters in a gram. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor MinGram(int? value)
	{
		Instance.MinGram = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Emits original token when set to <c>true</c>. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor PreserveOriginal(bool? value = true)
	{
		Instance.PreserveOriginal = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}