// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.MultiplexerTokenFilterConverter))]
public sealed partial class MultiplexerTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiplexerTokenFilter(System.Collections.Generic.ICollection<string> filters)
	{
		Filters = filters;
	}
#if NET7_0_OR_GREATER
	public MultiplexerTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MultiplexerTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MultiplexerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A list of token filters to apply to incoming tokens.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Filters { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then emit the original token in addition to the filtered tokens.
	/// </para>
	/// </summary>
	public bool? PreserveOriginal { get; set; }

	public string Type => "multiplexer";

	public string? Version { get; set; }
}

public readonly partial struct MultiplexerTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiplexerTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiplexerTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter(Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of token filters to apply to incoming tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor Filters(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Filters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of token filters to apply to incoming tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor Filters(params string[] values)
	{
		Instance.Filters = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then emit the original token in addition to the filtered tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor PreserveOriginal(bool? value = true)
	{
		Instance.PreserveOriginal = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}