// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.MinHashTokenFilterConverter))]
public sealed partial class MinHashTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public MinHashTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MinHashTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MinHashTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Number of buckets to which hashes are assigned. Defaults to <c>512</c>.
	/// </para>
	/// </summary>
	public int? BucketCount { get; set; }

	/// <summary>
	/// <para>
	/// Number of ways to hash each token in the stream. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public int? HashCount { get; set; }

	/// <summary>
	/// <para>
	/// Number of hashes to keep from each bucket. Defaults to <c>1</c>.
	/// Hashes are retained by ascending size, starting with the bucket’s smallest hash first.
	/// </para>
	/// </summary>
	public int? HashSetSize { get; set; }

	public string Type => "min_hash";

	public string? Version { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter fills empty buckets with the value of the first non-empty bucket to its circular right if the <c>hash_set_size</c> is <c>1</c>. If the <c>bucket_count</c> argument is greater than 1, this parameter defaults to <c>true</c>. Otherwise, this parameter defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? WithRotation { get; set; }
}

public readonly partial struct MinHashTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MinHashTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MinHashTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter(Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Number of buckets to which hashes are assigned. Defaults to <c>512</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor BucketCount(int? value)
	{
		Instance.BucketCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of ways to hash each token in the stream. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor HashCount(int? value)
	{
		Instance.HashCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hashes to keep from each bucket. Defaults to <c>1</c>.
	/// Hashes are retained by ascending size, starting with the bucket’s smallest hash first.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor HashSetSize(int? value)
	{
		Instance.HashSetSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter fills empty buckets with the value of the first non-empty bucket to its circular right if the <c>hash_set_size</c> is <c>1</c>. If the <c>bucket_count</c> argument is greater than 1, this parameter defaults to <c>true</c>. Otherwise, this parameter defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor WithRotation(bool? value = true)
	{
		Instance.WithRotation = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}