// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class LowercaseTokenFilterLanguagesConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGreek = System.Text.Json.JsonEncodedText.Encode("greek");
	private static readonly System.Text.Json.JsonEncodedText MemberIrish = System.Text.Json.JsonEncodedText.Encode("irish");
	private static readonly System.Text.Json.JsonEncodedText MemberTurkish = System.Text.Json.JsonEncodedText.Encode("turkish");

	public override Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGreek))
		{
			return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Greek;
		}

		if (reader.ValueTextEquals(MemberIrish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Irish;
		}

		if (reader.ValueTextEquals(MemberTurkish))
		{
			return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Turkish;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGreek.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Greek;
		}

		if (string.Equals(value, MemberIrish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Irish;
		}

		if (string.Equals(value, MemberTurkish.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Turkish;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Greek:
				writer.WriteStringValue(MemberGreek);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Irish:
				writer.WriteStringValue(MemberIrish);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages.Turkish:
				writer.WriteStringValue(MemberTurkish);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}