// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.LowercaseTokenFilterConverter))]
public sealed partial class LowercaseTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public LowercaseTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public LowercaseTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal LowercaseTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Language-specific lowercase token filter to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages? Language { get; set; }

	public string Type => "lowercase";

	public string? Version { get; set; }
}

public readonly partial struct LowercaseTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LowercaseTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LowercaseTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Language-specific lowercase token filter to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor Language(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterLanguages? value)
	{
		Instance.Language = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}