// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.LimitTokenCountTokenFilterConverter))]
public sealed partial class LimitTokenCountTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public LimitTokenCountTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public LimitTokenCountTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal LimitTokenCountTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the limit filter exhausts the token stream, even if the <c>max_token_count</c> has already been reached. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? ConsumeAllTokens { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of tokens to keep. Once this limit is reached, any remaining tokens are excluded from the output. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public int? MaxTokenCount { get; set; }

	public string Type => "limit";

	public string? Version { get; set; }
}

public readonly partial struct LimitTokenCountTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LimitTokenCountTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LimitTokenCountTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter(Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, the limit filter exhausts the token stream, even if the <c>max_token_count</c> has already been reached. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor ConsumeAllTokens(bool? value = true)
	{
		Instance.ConsumeAllTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of tokens to keep. Once this limit is reached, any remaining tokens are excluded from the output. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor MaxTokenCount(int? value)
	{
		Instance.MaxTokenCount = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}