// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.LengthTokenFilterConverter))]
public sealed partial class LengthTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public LengthTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public LengthTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal LengthTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Maximum character length of a token. Longer tokens are excluded from the output. Defaults to <c>Integer.MAX_VALUE</c>, which is <c>2^31-1</c> or <c>2147483647</c>.
	/// </para>
	/// </summary>
	public int? Max { get; set; }

	/// <summary>
	/// <para>
	/// Minimum character length of a token. Shorter tokens are excluded from the output. Defaults to <c>0</c>.
	/// </para>
	/// </summary>
	public int? Min { get; set; }

	public string Type => "length";

	public string? Version { get; set; }
}

public readonly partial struct LengthTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LengthTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LengthTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter(Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Maximum character length of a token. Longer tokens are excluded from the output. Defaults to <c>Integer.MAX_VALUE</c>, which is <c>2^31-1</c> or <c>2147483647</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor Max(int? value)
	{
		Instance.Max = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum character length of a token. Shorter tokens are excluded from the output. Defaults to <c>0</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor Min(int? value)
	{
		Instance.Min = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}