// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.KuromojiTokenizerConverter))]
public sealed partial class KuromojiTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KuromojiTokenizer(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode mode)
	{
		Mode = mode;
	}
#if NET7_0_OR_GREATER
	public KuromojiTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public KuromojiTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KuromojiTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public bool? DiscardCompoundToken { get; set; }
	public bool? DiscardPunctuation { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode Mode { get; set; }
	public int? NbestCost { get; set; }
	public string? NbestExamples { get; set; }

	public string Type => "kuromoji_tokenizer";

	public string? UserDictionary { get; set; }
	public System.Collections.Generic.ICollection<string>? UserDictionaryRules { get; set; }
	public string? Version { get; set; }
}

public readonly partial struct KuromojiTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KuromojiTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KuromojiTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor DiscardCompoundToken(bool? value = true)
	{
		Instance.DiscardCompoundToken = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor DiscardPunctuation(bool? value = true)
	{
		Instance.DiscardPunctuation = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor Mode(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode value)
	{
		Instance.Mode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor NbestCost(int? value)
	{
		Instance.NbestCost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor NbestExamples(string? value)
	{
		Instance.NbestExamples = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor UserDictionary(string? value)
	{
		Instance.UserDictionary = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor UserDictionaryRules(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.UserDictionaryRules = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor UserDictionaryRules(params string[] values)
	{
		Instance.UserDictionaryRules = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}