// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class KuromojiTokenizerConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer>
{
	private static readonly System.Text.Json.JsonEncodedText PropDiscardCompoundToken = System.Text.Json.JsonEncodedText.Encode("discard_compound_token");
	private static readonly System.Text.Json.JsonEncodedText PropDiscardPunctuation = System.Text.Json.JsonEncodedText.Encode("discard_punctuation");
	private static readonly System.Text.Json.JsonEncodedText PropMode = System.Text.Json.JsonEncodedText.Encode("mode");
	private static readonly System.Text.Json.JsonEncodedText PropNbestCost = System.Text.Json.JsonEncodedText.Encode("nbest_cost");
	private static readonly System.Text.Json.JsonEncodedText PropNbestExamples = System.Text.Json.JsonEncodedText.Encode("nbest_examples");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");
	private static readonly System.Text.Json.JsonEncodedText PropUserDictionary = System.Text.Json.JsonEncodedText.Encode("user_dictionary");
	private static readonly System.Text.Json.JsonEncodedText PropUserDictionaryRules = System.Text.Json.JsonEncodedText.Encode("user_dictionary_rules");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<bool?> propDiscardCompoundToken = default;
		LocalJsonValue<bool?> propDiscardPunctuation = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode> propMode = default;
		LocalJsonValue<int?> propNbestCost = default;
		LocalJsonValue<string?> propNbestExamples = default;
		LocalJsonValue<string?> propUserDictionary = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propUserDictionaryRules = default;
		LocalJsonValue<string?> propVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDiscardCompoundToken.TryReadProperty(ref reader, options, PropDiscardCompoundToken, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propDiscardPunctuation.TryReadProperty(ref reader, options, PropDiscardPunctuation, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propMode.TryReadProperty(ref reader, options, PropMode, null))
			{
				continue;
			}

			if (propNbestCost.TryReadProperty(ref reader, options, PropNbestCost, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNbestExamples.TryReadProperty(ref reader, options, PropNbestExamples, null))
			{
				continue;
			}

			if (reader.ValueTextEquals(PropType))
			{
				reader.SafeSkip();
				continue;
			}

			if (propUserDictionary.TryReadProperty(ref reader, options, PropUserDictionary, null))
			{
				continue;
			}

			if (propUserDictionaryRules.TryReadProperty(ref reader, options, PropUserDictionaryRules, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			DiscardCompoundToken = propDiscardCompoundToken.Value,
			DiscardPunctuation = propDiscardPunctuation.Value,
			Mode = propMode.Value,
			NbestCost = propNbestCost.Value,
			NbestExamples = propNbestExamples.Value,
			UserDictionary = propUserDictionary.Value,
			UserDictionaryRules = propUserDictionaryRules.Value,
			Version = propVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDiscardCompoundToken, value.DiscardCompoundToken, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropDiscardPunctuation, value.DiscardPunctuation, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropMode, value.Mode, null, null);
		writer.WriteProperty(options, PropNbestCost, value.NbestCost, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNbestExamples, value.NbestExamples, null, null);
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteProperty(options, PropUserDictionary, value.UserDictionary, null, null);
		writer.WriteProperty(options, PropUserDictionaryRules, value.UserDictionaryRules, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		writer.WriteEndObject();
	}
}