// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class KuromojiTokenizationModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberExtended = System.Text.Json.JsonEncodedText.Encode("extended");
	private static readonly System.Text.Json.JsonEncodedText MemberNormal = System.Text.Json.JsonEncodedText.Encode("normal");
	private static readonly System.Text.Json.JsonEncodedText MemberSearch = System.Text.Json.JsonEncodedText.Encode("search");

	public override Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberExtended))
		{
			return Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Extended;
		}

		if (reader.ValueTextEquals(MemberNormal))
		{
			return Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Normal;
		}

		if (reader.ValueTextEquals(MemberSearch))
		{
			return Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Search;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberExtended.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Extended;
		}

		if (string.Equals(value, MemberNormal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Normal;
		}

		if (string.Equals(value, MemberSearch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Search;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Extended:
				writer.WriteStringValue(MemberExtended);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Normal:
				writer.WriteStringValue(MemberNormal);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode.Search:
				writer.WriteStringValue(MemberSearch);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizationMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}