// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.KuromojiStemmerTokenFilterConverter))]
public sealed partial class KuromojiStemmerTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KuromojiStemmerTokenFilter(int minimumLength)
	{
		MinimumLength = minimumLength;
	}
#if NET7_0_OR_GREATER
	public KuromojiStemmerTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public KuromojiStemmerTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KuromojiStemmerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	int MinimumLength { get; set; }

	public string Type => "kuromoji_stemmer";

	public string? Version { get; set; }
}

public readonly partial struct KuromojiStemmerTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KuromojiStemmerTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KuromojiStemmerTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter(Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor MinimumLength(int value)
	{
		Instance.MinimumLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}