// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.KeywordMarkerTokenFilterConverter))]
public sealed partial class KeywordMarkerTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public KeywordMarkerTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public KeywordMarkerTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KeywordMarkerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, matching for the <c>keywords</c> and <c>keywords_path</c> parameters ignores letter case. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? IgnoreCase { get; set; }

	/// <summary>
	/// <para>
	/// Array of keywords. Tokens that match these keywords are not stemmed.
	/// This parameter, <c>keywords_path</c>, or <c>keywords_pattern</c> must be specified. You cannot specify this parameter and <c>keywords_pattern</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Keywords { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of keywords. Tokens that match these keywords are not stemmed.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each word in the file must be separated by a line break.
	/// This parameter, <c>keywords</c>, or <c>keywords_pattern</c> must be specified. You cannot specify this parameter and <c>keywords_pattern</c>.
	/// </para>
	/// </summary>
	public string? KeywordsPath { get; set; }

	/// <summary>
	/// <para>
	/// Java regular expression used to match tokens. Tokens that match this expression are marked as keywords and not stemmed.
	/// This parameter, <c>keywords</c>, or <c>keywords_path</c> must be specified. You cannot specify this parameter and <c>keywords</c> or <c>keywords_pattern</c>.
	/// </para>
	/// </summary>
	public string? KeywordsPattern { get; set; }

	public string Type => "keyword_marker";

	public string? Version { get; set; }
}

public readonly partial struct KeywordMarkerTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KeywordMarkerTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KeywordMarkerTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter(Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, matching for the <c>keywords</c> and <c>keywords_path</c> parameters ignores letter case. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor IgnoreCase(bool? value = true)
	{
		Instance.IgnoreCase = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of keywords. Tokens that match these keywords are not stemmed.
	/// This parameter, <c>keywords_path</c>, or <c>keywords_pattern</c> must be specified. You cannot specify this parameter and <c>keywords_pattern</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor Keywords(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Keywords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of keywords. Tokens that match these keywords are not stemmed.
	/// This parameter, <c>keywords_path</c>, or <c>keywords_pattern</c> must be specified. You cannot specify this parameter and <c>keywords_pattern</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor Keywords(params string[] values)
	{
		Instance.Keywords = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of keywords. Tokens that match these keywords are not stemmed.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each word in the file must be separated by a line break.
	/// This parameter, <c>keywords</c>, or <c>keywords_pattern</c> must be specified. You cannot specify this parameter and <c>keywords_pattern</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor KeywordsPath(string? value)
	{
		Instance.KeywordsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Java regular expression used to match tokens. Tokens that match this expression are marked as keywords and not stemmed.
	/// This parameter, <c>keywords</c>, or <c>keywords_path</c> must be specified. You cannot specify this parameter and <c>keywords</c> or <c>keywords_pattern</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor KeywordsPattern(string? value)
	{
		Instance.KeywordsPattern = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}