// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.KeepWordsTokenFilterConverter))]
public sealed partial class KeepWordsTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public KeepWordsTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public KeepWordsTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KeepWordsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// List of words to keep. Only tokens that match words in this list are included in the output.
	/// Either this parameter or <c>keep_words_path</c> must be specified.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? KeepWords { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, lowercase all keep words. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? KeepWordsCase { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of words to keep. Only tokens that match words in this list are included in the output.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each word in the file must be separated by a line break.
	/// Either this parameter or <c>keep_words</c> must be specified.
	/// </para>
	/// </summary>
	public string? KeepWordsPath { get; set; }

	public string Type => "keep";

	public string? Version { get; set; }
}

public readonly partial struct KeepWordsTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KeepWordsTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KeepWordsTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter(Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// List of words to keep. Only tokens that match words in this list are included in the output.
	/// Either this parameter or <c>keep_words_path</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor KeepWords(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.KeepWords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of words to keep. Only tokens that match words in this list are included in the output.
	/// Either this parameter or <c>keep_words_path</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor KeepWords(params string[] values)
	{
		Instance.KeepWords = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, lowercase all keep words. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor KeepWordsCase(bool? value = true)
	{
		Instance.KeepWordsCase = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of words to keep. Only tokens that match words in this list are included in the output.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each word in the file must be separated by a line break.
	/// Either this parameter or <c>keep_words</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor KeepWordsPath(string? value)
	{
		Instance.KeepWordsPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}