// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.KeepTypesTokenFilterConverter))]
public sealed partial class KeepTypesTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KeepTypesTokenFilter(System.Collections.Generic.ICollection<string> types)
	{
		Types = types;
	}
#if NET7_0_OR_GREATER
	public KeepTypesTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public KeepTypesTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KeepTypesTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to keep or remove the specified token types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepTypesMode? Mode { get; set; }

	public string Type => "keep_types";

	/// <summary>
	/// <para>
	/// List of token types to keep or remove.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Types { get; set; }
	public string? Version { get; set; }
}

public readonly partial struct KeepTypesTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KeepTypesTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KeepTypesTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter(Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Indicates whether to keep or remove the specified token types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor Mode(Elastic.Clients.Elasticsearch.Analysis.KeepTypesMode? value)
	{
		Instance.Mode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of token types to keep or remove.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor Types(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Types = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of token types to keep or remove.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor Types(params string[] values)
	{
		Instance.Types = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}