// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class IcuTransformDirectionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection>
{
	private static readonly System.Text.Json.JsonEncodedText MemberForward = System.Text.Json.JsonEncodedText.Encode("forward");
	private static readonly System.Text.Json.JsonEncodedText MemberReverse = System.Text.Json.JsonEncodedText.Encode("reverse");

	public override Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberForward))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection.Forward;
		}

		if (reader.ValueTextEquals(MemberReverse))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection.Reverse;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberForward.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection.Forward;
		}

		if (string.Equals(value, MemberReverse.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection.Reverse;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection.Forward:
				writer.WriteStringValue(MemberForward);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection.Reverse:
				writer.WriteStringValue(MemberReverse);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuTransformDirection value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}