// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.IcuTokenizerConverter))]
public sealed partial class IcuTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuTokenizer(string ruleFiles)
	{
		RuleFiles = ruleFiles;
	}
#if NET7_0_OR_GREATER
	public IcuTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IcuTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IcuTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	string RuleFiles { get; set; }

	public string Type => "icu_tokenizer";

	public string? Version { get; set; }
}

public readonly partial struct IcuTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer(Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor RuleFiles(string value)
	{
		Instance.RuleFiles = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}