// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class IcuNormalizationTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberNfc = System.Text.Json.JsonEncodedText.Encode("nfc");
	private static readonly System.Text.Json.JsonEncodedText MemberNfkc = System.Text.Json.JsonEncodedText.Encode("nfkc");
	private static readonly System.Text.Json.JsonEncodedText MemberNfkcCf = System.Text.Json.JsonEncodedText.Encode("nfkc_cf");

	public override Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberNfc))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.Nfc;
		}

		if (reader.ValueTextEquals(MemberNfkc))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.Nfkc;
		}

		if (reader.ValueTextEquals(MemberNfkcCf))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.NfkcCf;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberNfc.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.Nfc;
		}

		if (string.Equals(value, MemberNfkc.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.Nfkc;
		}

		if (string.Equals(value, MemberNfkcCf.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.NfkcCf;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.Nfc:
				writer.WriteStringValue(MemberNfc);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.Nfkc:
				writer.WriteStringValue(MemberNfkc);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType.NfkcCf:
				writer.WriteStringValue(MemberNfkcCf);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}