// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class IcuNormalizationModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCompose = System.Text.Json.JsonEncodedText.Encode("compose");
	private static readonly System.Text.Json.JsonEncodedText MemberDecompose = System.Text.Json.JsonEncodedText.Encode("decompose");

	public override Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCompose))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode.Compose;
		}

		if (reader.ValueTextEquals(MemberDecompose))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode.Decompose;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCompose.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode.Compose;
		}

		if (string.Equals(value, MemberDecompose.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode.Decompose;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode.Compose:
				writer.WriteStringValue(MemberCompose);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode.Decompose:
				writer.WriteStringValue(MemberDecompose);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}