// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.IcuFoldingTokenFilterConverter))]
public sealed partial class IcuFoldingTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuFoldingTokenFilter(string unicodeSetFilter)
	{
		UnicodeSetFilter = unicodeSetFilter;
	}
#if NET7_0_OR_GREATER
	public IcuFoldingTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IcuFoldingTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IcuFoldingTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string Type => "icu_folding";

	public
#if NET7_0_OR_GREATER
	required
#endif
	string UnicodeSetFilter { get; set; }
	public string? Version { get; set; }
}

public readonly partial struct IcuFoldingTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuFoldingTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuFoldingTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter(Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor UnicodeSetFilter(string value)
	{
		Instance.UnicodeSetFilter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}