// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class IcuCollationStrengthConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength>
{
	private static readonly System.Text.Json.JsonEncodedText MemberIdentical = System.Text.Json.JsonEncodedText.Encode("identical");
	private static readonly System.Text.Json.JsonEncodedText MemberPrimary = System.Text.Json.JsonEncodedText.Encode("primary");
	private static readonly System.Text.Json.JsonEncodedText MemberQuaternary = System.Text.Json.JsonEncodedText.Encode("quaternary");
	private static readonly System.Text.Json.JsonEncodedText MemberSecondary = System.Text.Json.JsonEncodedText.Encode("secondary");
	private static readonly System.Text.Json.JsonEncodedText MemberTertiary = System.Text.Json.JsonEncodedText.Encode("tertiary");

	public override Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberIdentical))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Identical;
		}

		if (reader.ValueTextEquals(MemberPrimary))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Primary;
		}

		if (reader.ValueTextEquals(MemberQuaternary))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Quaternary;
		}

		if (reader.ValueTextEquals(MemberSecondary))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Secondary;
		}

		if (reader.ValueTextEquals(MemberTertiary))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Tertiary;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberIdentical.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Identical;
		}

		if (string.Equals(value, MemberPrimary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Primary;
		}

		if (string.Equals(value, MemberQuaternary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Quaternary;
		}

		if (string.Equals(value, MemberSecondary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Secondary;
		}

		if (string.Equals(value, MemberTertiary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Tertiary;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Identical:
				writer.WriteStringValue(MemberIdentical);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Primary:
				writer.WriteStringValue(MemberPrimary);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Quaternary:
				writer.WriteStringValue(MemberQuaternary);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Secondary:
				writer.WriteStringValue(MemberSecondary);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength.Tertiary:
				writer.WriteStringValue(MemberTertiary);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuCollationStrength value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}