// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class IcuCollationCaseFirstConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst>
{
	private static readonly System.Text.Json.JsonEncodedText MemberLower = System.Text.Json.JsonEncodedText.Encode("lower");
	private static readonly System.Text.Json.JsonEncodedText MemberUpper = System.Text.Json.JsonEncodedText.Encode("upper");

	public override Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberLower))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst.Lower;
		}

		if (reader.ValueTextEquals(MemberUpper))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst.Upper;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberLower.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst.Lower;
		}

		if (string.Equals(value, MemberUpper.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst.Upper;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst.Lower:
				writer.WriteStringValue(MemberLower);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst.Upper:
				writer.WriteStringValue(MemberUpper);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuCollationCaseFirst value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}