// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class IcuCollationAlternateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate>
{
	private static readonly System.Text.Json.JsonEncodedText MemberNonIgnorable = System.Text.Json.JsonEncodedText.Encode("non-ignorable");
	private static readonly System.Text.Json.JsonEncodedText MemberShifted = System.Text.Json.JsonEncodedText.Encode("shifted");

	public override Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberNonIgnorable))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate.NonIgnorable;
		}

		if (reader.ValueTextEquals(MemberShifted))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate.Shifted;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberNonIgnorable.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate.NonIgnorable;
		}

		if (string.Equals(value, MemberShifted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate.Shifted;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate.NonIgnorable:
				writer.WriteStringValue(MemberNonIgnorable);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate.Shifted:
				writer.WriteStringValue(MemberShifted);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IcuCollationAlternate value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}